package chess4j.board;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import chess4j.moves.Move;




public class Undo {

	private Move _move;
	private int _fiftyCounter;
	private Set<CastlingRights> _castlingRights = new HashSet<CastlingRights>();
	private Square _epSquare;
	
	public Undo(Move move,int fiftyCounter,Set<CastlingRights> castlingRights,Square epSquare) {
		_move=move;
		_fiftyCounter=fiftyCounter;
		_castlingRights.addAll(castlingRights);
		_epSquare=epSquare;
	}

	public Set<CastlingRights> getCastlingRights() {
		return Collections.unmodifiableSet(_castlingRights);
	}

	public Square getEpSquare() {
		return _epSquare;
	}

	public int getFiftyCounter() {
		return _fiftyCounter;
	}

	public Move getMove() {
		return _move;
	}
}
